package com.agilex.healthcare.veteranappointment.datalayer.appointment;

import java.util.Date;

import javax.annotation.Resource;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.veteranappointment.datalayer.feedback.UserFeedbackDataLayerRepo;
import com.agilex.healthcare.veteranappointment.domain.VARAppointmentProcessedAsPerUserNeed;
import com.agilex.healthcare.veteranappointment.domain.VARFeedback;
import com.agilex.healthcare.veteranappointment.utils.SpringBasedIntegrationRepo;

public class UserFeedbackDataLayerRepoTest extends SpringBasedIntegrationRepo{

	@Resource
	UserFeedbackDataLayerRepo userFeedbackDataLayer;
	
	@Before
	public void setUp() throws Exception {
		super.setUp();
	}
	
	@After
	public void tearDown() throws Exception {
		super.tearDown();
	}
	
	@Test
	public void testSaveFeedback() {
		VARFeedback feedback = new VARFeedback();
		feedback.setAppointmentProcessedAsPerUserNeed(VARAppointmentProcessedAsPerUserNeed.Always);
		feedback.setRecommendationRating(5);
		feedback.setComments("Appointments app works great");
		feedback.setDateCreated(new Date());
		feedback = userFeedbackDataLayer.saveUserFeedback(feedback);
		assertNotNull(feedback.getUniqueId());
	}

}
